// Written by Joseph Vohnoutka, vohno013
public class Knight {
    // Instance variables
    private int row;
    private int col;
    private boolean isBlack;

    /**
     * Constructor.
     *
     * @param row     The current row of the knight.
     * @param col     The current column of the knight.
     * @param isBlack The color of the knight.
     */
    public Knight(int row, int col, boolean isBlack) {
        this.row = row;
        this.col = col;
        this.isBlack = isBlack;
    }

    public boolean isMoveLegal(Board board, int endRow, int endCol) {
        // verifies the required parameters for the move to be legal
        // checks if either row or column changes by 1 and the other changes by 2
        if (board.verifySourceAndDestination(row, col, endRow, endCol, isBlack) && ((Math.abs(row - endRow) == 1 && Math.abs(col - endCol) == 2) || (Math.abs(row - endRow) == 2 && Math.abs(col - endCol) == 1))) {
            return true;
        } else return false;
    }
}
