// Written by Joseph Vohnoutka, vohno013
public class King {
    // Instance variables
    private int row;
    private int col;
    private boolean isBlack;

    /**
     * Constructor.
     *
     * @param row     The current row of the king.
     * @param col     The current column of the king.
     * @param isBlack The color of the king.
     */
    public King(int row, int col, boolean isBlack) {
        this.row = row;
        this.col = col;
        this.isBlack = isBlack;
    }

    public boolean isMoveLegal(Board board, int endRow, int endCol) {
        // verifies the required parameters for the move to be legal
        if (board.verifySourceAndDestination(row, col, endRow, endCol, isBlack) && board.verifyAdjacent(row, col, endRow, endCol)) {
            return true;
        } else return false;
    }
}
