// Written by Joseph Vohnoutka, vohno013

import java.util.Scanner;

public class Game {
    public static boolean currentPlayerBlack = false;

    public static int[] promptPlayer(Board currentBoard) {
        // Prompts user to enter their move and verifies its valid.
        String color = "white";
        if (currentPlayerBlack) color = "black";
        System.out.println("It is currently " + color + "'s turn to play.\n" +
                "What is your move? (format: [start row] [start col] [end row] [end col])");
        Scanner readMoveScanner = new Scanner(System.in);
        int startRow, startCol, endRow, endCol;
        startRow = endRow = startCol = endCol = -1;
        while (!currentBoard.verifySourceAndDestination(startRow, startCol, endRow, endCol, currentPlayerBlack)) {
            if (readMoveScanner.hasNext()) {
                String[] enteredNumbersArray = readMoveScanner.nextLine().split(" ");
                // gets numbers inputted by the user.
                try {
                    startRow = Integer.parseInt(enteredNumbersArray[0]);
                    startCol = Integer.parseInt(enteredNumbersArray[1]);
                    endRow = Integer.parseInt(enteredNumbersArray[2]);
                    endCol = Integer.parseInt(enteredNumbersArray[3]);
                    if (!currentBoard.verifySourceAndDestination(startRow, startCol, endRow, endCol, currentPlayerBlack) || !currentBoard.getPiece(startRow, startCol).isMoveLegal(currentBoard, endRow, endCol)) {
                        System.out.print(currentBoard);
                        System.out.println("It is currently " + color + "'s turn to play.\n" +
                                "Invalid move. Please enter a valid move in the format of [start row] [start col] [end row] [end col].");
                        startRow = endRow = startCol = endCol = -1;
                    }
                } catch (Exception e) {
                    System.out.print(currentBoard);
                    System.out.println("It is currently " + color + "'s turn to play.\n" +
                            "Please enter 4 numbers in the format of [start row] [start col] [end row] [end col]");
                }
                // makes sure the move can be made by the piece

            }
        }
        int[] returnArray = {startRow, startCol, endRow, endCol};
        return returnArray;
    }

    public static void promptPromotePawn(Board currentBoard, Piece pawn) {
        // prompts the user to select a piece to upgrade their pawn to
        String enteredString = "";
        Scanner readUpgrade = new Scanner(System.in);
        while (!pawn.pawnPromotion(enteredString)) {
            System.out.println("Enter the piece you want to upgrade the pawn to (options: 'Queen', 'Rook', 'Bishop', 'Knight')");
            enteredString = readUpgrade.nextLine();
        }
    }

    public static void main(String[] args) {
        Board currentBoard = new Board();
        Fen.load("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR", currentBoard);
        // Loops as long as both kings are present
        while (!currentBoard.isGameOver()) {
            System.out.print(currentBoard);
            int startRow, startCol, endRow, endCol;
            // prompts player to enter a move and gets the response
            int[] promptResponse = promptPlayer(currentBoard);
            startRow = promptResponse[0];
            startCol = promptResponse[1];
            endRow = promptResponse[2];
            endCol = promptResponse[3];
            // carries out the move entered by the player.
            currentBoard.movePiece(startRow, startCol, endRow, endCol);
            // If the move just entered moves a pawn to the opposite end of the board, the user is prompted to upgrade their pawn
            if ((endRow == 0 || endRow == 7) && (currentBoard.getPiece(endRow, endCol).toString().equals("\u2659") || currentBoard.getPiece(endRow, endCol).toString().equals("\u265f"))) {
                promptPromotePawn(currentBoard, currentBoard.getPiece(endRow, endCol));
            }
            // Switches the current player
            currentPlayerBlack = !currentPlayerBlack;
        }
        // flips current player to get the last player that made a move
        currentPlayerBlack = !currentPlayerBlack;
        String color = "White";
        if (currentPlayerBlack) color = "Black";
        // Prints the winner color
        System.out.println(color + " has won the game!");

    }
}
