// Written by Joseph Vohnoutka, vohno013
public class Bishop {
    // Instance variables
    private int row;
    private int col;
    private boolean isBlack;

    /**
     * Constructor.
     *
     * @param row     The current row of the bishop.
     * @param col     The current column of the bishop.
     * @param isBlack The color of the bishop.
     */
    public Bishop(int row, int col, boolean isBlack) {
        this.row = row;
        this.col = col;
        this.isBlack = isBlack;
    }

    public boolean isMoveLegal(Board board, int endRow, int endCol) {
        // verifies the required parameters for the move to be legal
        if (board.verifySourceAndDestination(row, col, endRow, endCol, isBlack) && board.verifyDiagonal(row, col, endRow, endCol)) {
            return true;
        } else return false;
    }
}
